////////////////////////////////////////////////////////////////////////////////
// O  FTCPCommunication.cpp
// 쐬ҁFMasahiro Nakajima
// XVF2001/8/29
// pr@FMMIVXeW[ԒʐMp
////////////////////////////////////////////////////////////////////////////////
// Tv@FEW[Ԃő󂳂f[^̂sB
// @@@FEۂɑMf[^́AƂĎ󂯎MbZ[W
// @@@Fwb_t́B
////////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "TCPCommunication.h"
#include "winsock.h"
#include "sys/types.h"
#include "sys/timeb.h"
#include <malloc.h>
#include <process.h>

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
// Xbh̎
// Xbhœ삷O֐ibZ[WMpj
//CTCPCommunication *TCPCom = new CTCPCommunication();
//
//void StartTCPServerThread(void *dummy)
//{
//	TCPCom->TCPServer();
//};
//
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
// publicȃ\bh

/*******************************************************************************
 ֐  :CTCPCommunication::CTCPCommunication()
 @\    :ftHgRXgN^
     :Ȃ
 ߂l  :Ȃ
 쐬  :Masahiro Nakajima
 쐬  :
*******************************************************************************/
CTCPCommunication::CTCPCommunication()
{
}


/*******************************************************************************
 ֐  :CTCPCommunication::~CTCPCommunication()
 @\    :ftHgfXgN^
     :Ȃ
 ߂l  :Ȃ
 쐬  :Masahiro Nakajima
 쐬  :
*******************************************************************************/
CTCPCommunication::~CTCPCommunication()
{
}


/*******************************************************************************
 ֐  :void CTCPCommunication::Initialize(char *myname)
 @\    :
     :*myname - ʐMW[̖OiAddressInfo.txtɋLqẮj
 ߂l  :Ȃ
 쐬  :Masahiro Nakajima
 쐬  :
*******************************************************************************/
void CTCPCommunication::Initialize(char *myname)
{
	// Xg֘A̕ϐ
	ListLength = 0;
	CellHead = CellTail = NULL;

	// trueɂƃ\PbgM[vI
	EndSignal = false;
	
	// \Pbg̎Mf[^̐ݒ
	strcpy(MyName, myname);

	// ԏ擾
	SetStartedTime();

	// Windows Sockets
	WSADATA Data;
	WSAStartup(0x0101, &Data);

}


/*******************************************************************************
 ֐  :int CTCPCommunication::CheckListLength()
 @\    :MbZ[W̃Xg̒𒲂ׂ
     :Ȃ
 ߂l  :MbZ[W̃Xg̒
 쐬  :Masahiro Nakajima
 쐬  :
*******************************************************************************/
int CTCPCommunication::CheckListLength()
{
	return ListLength;
}


/*******************************************************************************
 ֐  :int CTCPCommunication::GetMMBox(struct MMessageBox *MMBox)
 @\    :MbZ[W󂯎
     :*MMBox - bZ[W̃f[^i[\̂̃|C^
 ߂l  : 0  s 1
 쐬  :Masahiro Nakajima
 쐬  :
 *******************************************************************************/
int CTCPCommunication::GetMMBox(struct MMessageBox *MMBox)
{
	// Xg̒`FbNĂ烁bZ[Wo
	// 0̃XgoƃG[oEEE
	if(ListLength > 0){
		// MbZ[WXgMMessageBoxo
		strcpy(MMBox->addr_from, CellHead->addr_from);
		strcpy(MMBox->addr_to, CellHead->addr_to);
		MMBox->time = atol(CellHead->time);
		strcpy(MMBox->message, CellHead->message);

		DeleteCell();
	
		return 0;
	}
	else
	{
		return 1;
	}
}


/*******************************************************************************
 ֐  :int CTCPCommunication::SetAddressFrom(char *from)
 @\    :MAhXݒ肷
     :*from - M̖OiAddressInfo.txtQƁj
 ߂l  : 0
 쐬  :Masahiro Nakajima
 쐬  :
*******************************************************************************/
int CTCPCommunication::SetAddressFrom(char *from)
{
	strcpy(SendMMBox.addr_from, from); 
	return 0;
}


/*******************************************************************************
 ֐  :int CTCPCommunication::SetAddressTo(char *to)
 @\    :M̃AhXݒ肷
     :*to - M̖OiAddressInfo.txtQƁj
 ߂l  : 0
 쐬  :Masahiro Nakajima
 쐬  :
*******************************************************************************/
int CTCPCommunication::SetAddressTo(char *to)
{
	strcpy(SendMMBox.addr_to, to);
	return 0;
}


/*******************************************************************************
 ֐  :int CTCPCommunication::SetMessage(char *message)
 @\    :M镶ݒ肷
     :*message - M镶̃|C^
 ߂l  : 0
 쐬  :Masahiro Nakajima
 쐬  :
*******************************************************************************/
int CTCPCommunication::SetMessage(char *message)
{
	strcpy(SendMMBox.message, message);
	return 0;
}


/*******************************************************************************
 ֐  :int CTCPCommunication::SetMMBox(struct MMessageBox *box)
 @\    :Mf[^̓MMessageBox\̂^
     :*box - ԈȊÕf[^MMessageBox\̂̃|C^
 ߂l  : 0
 쐬  :Masahiro Nakajima
 쐬  :
*******************************************************************************/
int CTCPCommunication::SetMMBox(struct MMessageBox *box)
{
	strcpy(SendMMBox.addr_from, box->addr_from);
	strcpy(SendMMBox.addr_to, box->addr_to);
	strcpy(SendMMBox.message, box->message);

	return 0;
}


/*******************************************************************************
 ֐  :int CTCPCommunication::SendModuleMessage()
 @\    :ModuleMessagȇM
     :Ȃ
 ߂l  : 0  s 1
 쐬  :Masahiro Nakajima
 쐬  :
*******************************************************************************/
int CTCPCommunication::SendModuleMessage()
{
	// MAhX̐ݒ
	struct sockaddr_in TargetAddress;
	
	if(MakeModuleMessage(ModuleMessage) == 1){return 1;}

	// \Pbg쐬
	SOCKET ClientSock;
	if ((ClientSock = socket(AF_INET, SOCK_STREAM, 0)) == INVALID_SOCKET)
	{
		//TRACE("M\Pbg쐬s");
		return 1;
	}

	// M̐ݒ
	if (SetTargetAddress(&TargetAddress) != 0){return 1;}
	// ɐڑ
	if (connect(ClientSock, (struct sockaddr *)&TargetAddress, sizeof(TargetAddress)) < 0)
	{
		//TRACE("MɐڑłȂI");
		return 1;
	}

	// bZ[W𑗐M
	send(ClientSock, ModuleMessage, MODULE_MESSAGE_LENGTH, 0);

	// ڑ؂
	closesocket(ClientSock);

	return 0;

}


/*******************************************************************************
 ֐  :void CTCPCommunication::TCPServer()
 @\    :bZ[WM
     :Ȃ
 ߂l  :Ȃ
 쐬  :Masahiro Nakajima
 쐬  :
 gp@:O֐XbhƂČĂяo
*******************************************************************************/
void CTCPCommunication::TCPServer()
{
	char ReceiveMessage[MODULE_MESSAGE_LENGTH];
	char port[PORT_NUMBER_LENGTH];
	struct sockaddr_in MyAddress;
	SOCKET ServerSock;

	// NT[o[̃|[g𒲂ׂ
	GetAddressInfo(port, MyName, 2);
	
	// \Pbg쐬
	if ((ServerSock = socket(AF_INET, SOCK_STREAM, 0)) == INVALID_SOCKET)
	{
		// Mp\Pbg̍쐬ɎsƂ̃G[
		//TRACE("M\PbgŎs");
		_endthread();
		CWnd* pWnd;
		pWnd = AfxGetMainWnd();
		pWnd->SendMessage(WM_CLOSE);
	}

	// \PbgɃAhXt
	memset(&MyAddress, 0, sizeof(MyAddress));
	MyAddress.sin_family = AF_INET;
	MyAddress.sin_port = htons(atoi(port));
	MyAddress.sin_addr.s_addr = INADDR_ANY;
	if (bind(ServerSock, (struct sockaddr *)&MyAddress, sizeof(MyAddress)) == SOCKET_ERROR)
	{
		// Mp\Pbgւ̃AhXtɎs̃G[
		//TRACE("M\PbgAhXtŎs");
		_endthread();
		CWnd* pWnd;
		pWnd = AfxGetMainWnd();
		pWnd->SendMessage(WM_CLOSE);
	}

	// \Pbgւ̃RlNV҂ɓ
	if (listen(ServerSock, 5) < 0)
	{
		// TCPڑ҂ŃG[Ƃ̃G[
		//TRACE("ڑ҂ŃG[");
		_endthread();
		CWnd* pWnd;
		pWnd = AfxGetMainWnd();
		pWnd->SendMessage(WM_CLOSE);
	}

	while(EndSignal != true){
		// \Pbgւ̃RlNV󂯓
		struct sockaddr_in SockFrom;
		int SockFromSize = sizeof(SockFrom);
		SOCKET ResSock;
		if ((ResSock = accept(ServerSock, (struct sockaddr *)&SockFrom, &SockFromSize)) < 0)		    {
			// TCPڑŃG[Ƃ̃G[
			//TRACE("ڑŃG[");
			_endthread();
			CWnd* pWnd;
			pWnd = AfxGetMainWnd();
			pWnd->SendMessage(WM_CLOSE);
		}
		else
		{
			// 肩̃f[^M
			recv(ResSock, ReceiveMessage, MODULE_MESSAGE_LENGTH, 0);
			
			// MbZ[WXgɒǉ
			MakeMessageQueue(ReceiveMessage);
			
			// _~[f[^̎M
			// 葤ڑؒf邽0Ԃ͂
			recv(ResSock, ReceiveMessage, 1, 0);

			// ڑ̐ؒf
			closesocket(ResSock);
		}
	}

	closesocket(ServerSock);

	// WinScokmۂĂ郊\[X̊J
	WSACleanup();
}


/*******************************************************************************
 ֐  :void CTCPCommunication::EndSocketRecept()
 @\    :\Pbg̎Ms[vƂ߂
     :Ȃ
 ߂l  :Ȃ
 쐬  :Masahiro Nakajima
 쐬  :
*******************************************************************************/
void CTCPCommunication::EndSocketRecept()
{
	EndSignal = true;

	while(ListLength != 0)
	{
		DeleteCell();
	}
}


////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
// privateȃ\bh

/*******************************************************************************
 ֐  :void CTCPCommunication::SetStartedTime()
 @\    :{ԏ𓾂
     :Ȃ
 ߂l  :Ȃ
 쐬  :Masahiro Nakajima
 쐬  :
*******************************************************************************/
void CTCPCommunication::SetStartedTime()
{
	_ftime(&StartedTime);	
}


/*******************************************************************************
 ֐  :int CTCPCommunication::GetAddressInfo(char *DataStr, char *Condition, char *Target)
 @\    :IPAhX`t@Cɂf[^o
     :*DataStr - of[^ۑ|C^
	 :*Condition - Ɠ񎝂tB[h
	 :*Field - of[^̎ށi0`2F0 - name, 1 - ip, 2 - portj
 ߂l  : 0  s 1
 쐬  :Masahiro Nakajima
 쐬  :
*******************************************************************************/
int CTCPCommunication::GetAddressInfo(char *DataStr, char *Condition, int Field)
{
	char name[21],ip[16],port[6],*ReturnStr;
	FILE *fp;

	// t@Cǂݎf[^߂
	if( -1 < Field && Field < 3)
	{
		switch(Field)
		{
			case 0 : ReturnStr = name; break;
			case 1 : ReturnStr = ip; break;
			case 2 : ReturnStr = port; break;
			default: return 1;
		}
	}

	if((fp = fopen(FILE_NAME, "r")) == NULL)
	{
		// `t@Cǂݍ݂ɎsƂ̃G[
		//TRACE("AddressInfo.txt̓ǂݎ莸s");
		return 1;
	}

	// Pst@Cǂݍ
	// TargetNameƈvnametB[hIP\̂Ɋi[
	while(!feof(fp))
	{
		fscanf(fp,"%s %s %s", name, ip, port);
		
		if(strcmp(name, Condition) == 0)
		{
			strcpy(DataStr, ReturnStr);
			fclose(fp);
			return 0;
		}
	}
	
	fclose(fp);
	return 1;
}

/*******************************************************************************
 ֐  :int CTCPCommunication::MakeModuleMessage(char *mes)
 @\    :MMessageBoxۑM镶쐬
     :*mes - i[|C^
 ߂l  : 0
 쐬  :Masahiro Nakajima
 쐬  :
*******************************************************************************/
int CTCPCommunication::MakeModuleMessage(char *mes)
{
	CString Head;
	CString Data;
	CString ModuleMessage;
	char time_buff[11];

	// Ύԏ̍쐬
	ultoa(GetCurrentTime(), time_buff, 10);
	
	Head.Format("<Head><From>%s</From><To>%s</To><Time>%s</Time></Head>", SendMMBox.addr_from, SendMMBox.addr_to, time_buff);
	Data.Format("<Data>%s</Data>", SendMMBox.message);
	
	ModuleMessage.Format("<MML>%s%s</MML>", (LPCSTR)Head, (LPCSTR)Data);

	strcpy(mes, (LPCSTR)ModuleMessage);
	return 0;
}


/*******************************************************************************
 ֐  :unsigned long int CTCPCommunication::GetCurrentTime()
 @\    :^CX^vƂđΎԏ쐬
     :Ȃ
 ߂l  :VXeŇo߃~b
 쐬  :Masahiro Nakajima
 쐬  :
*******************************************************************************/
unsigned long int CTCPCommunication::GetCurrentTime()
{
	struct _timeb CurrentTime;
	unsigned long int RelativeTimeInfo;

	_ftime(&CurrentTime);

	// PDݎ̌oߕb{̌oߕb
	// QDʂ1000{A~b̐l𑫂
	// RDQ̒l{̃~b̒l
	RelativeTimeInfo = CurrentTime.time - StartedTime.time;
	RelativeTimeInfo = 1000 * RelativeTimeInfo + CurrentTime.millitm;
	RelativeTimeInfo -= StartedTime.millitm;

	return RelativeTimeInfo;
}


/*******************************************************************************
 ֐  :int CTCPCommunication::ExtractMMessageBox(char *mes, struct MMessageBox *tempBox)
 @\    :MbZ[WMMessageBox\̂Ɋi[
     :*mes - MbZ[W
	 :*tempBox - f[^i[MMessageBox\̂̃|C^
 ߂l  : 0
 쐬  :Masahiro Nakajima
 쐬  :
*******************************************************************************/
int CTCPCommunication::ExtractMMessageBox(char *mes, struct MMessageBox *tempBox)
{
	CString WorkMes = mes;
	CString TempMes;

	// <MML></MML>
	WorkMes.Delete(WorkMes.GetLength() - 6, 6);
	WorkMes.Delete(0, 5);

	// <Head><From>āA\̂ɑMAhXi[
	WorkMes.Delete(0, 12);
	TempMes = WorkMes.Left(WorkMes.FindOneOf("<"));
	strcpy(tempBox->addr_from, (LPCSTR)TempMes);

	// MAhX</From><to>A\̂ɑMAhXi[
	WorkMes.Delete(0, WorkMes.FindOneOf("<") + 11);
	TempMes = WorkMes.Left(WorkMes.FindOneOf("<"));
	strcpy(tempBox->addr_to, (LPCSTR)TempMes);

	// MAhX</to><time>A\̂Ƀ^CX^vi[
	WorkMes.Delete(0, WorkMes.FindOneOf("<") + 11);
	TempMes = WorkMes.Left(WorkMes.FindOneOf("<"));
	tempBox->time = atoi((LPCSTR)TempMes);

	// ^CX^v</time></Head><Data>A\̂ɃbZ[Wi[
	WorkMes.Delete(0, WorkMes.FindOneOf("<") + 20);
	WorkMes.Delete(WorkMes.GetLength() - 7, 7);
	strcpy(tempBox->message,(LPCSTR)WorkMes);

	return 0;
}


/*******************************************************************************
 ֐  :int CTCPCommunication::SetTargetAddress(struct sockaddr_in *target)
 @\    :M̃AhXݒ肷
     :*target - AhXi[\̂̃|C^
 ߂l  : 0
 쐬  :Masahiro Nakajima
 쐬  :
 gp@:SendModuleMessage()Ă
*******************************************************************************/
int CTCPCommunication::SetTargetAddress(struct sockaddr_in *target)
{
	char port[6];
	char ip[16];

	// M薼IPAhXƃ|[gԍo
	GetAddressInfo(port, SendMMBox.addr_to, 2);
	GetAddressInfo(ip, SendMMBox.addr_to, 1);
	// 
	memset(target, 0, sizeof(&target));
	// IPAhX̐ݒ
	target->sin_addr.s_addr = inet_addr(ip);
	// |[gԍ̐ݒ
	target->sin_port = htons(atoi(port));
	// ʐMhC̐ݒ
	target->sin_family = AF_INET;

	return 0;
}


/*******************************************************************************
 ֐  :void CTCPCommunication::MakeMessageQueue(char *ReceiveMessage)
 @\    :MbZ[W̃Xg
     :*ReceiveMessage - MbZ[WiĂȂԂ̕j
 ߂l  :Ȃ
 쐬  :Masahiro Nakajima
 쐬  :
 gp@:TCPServer()Ă
*******************************************************************************/
void CTCPCommunication::MakeMessageQueue(char *ReceiveMessage)
{
	struct MMessageBox tempBox;
	struct MMessageBoxCell *Cell;

	// MbZ[WMMessageBox\̂Ɋi[
	if(ExtractMMessageBox(ReceiveMessage, &tempBox) != 0)
	{
		// MbZ[W̕ɎsƂ̏
		//TRACE("MbZ[Ws");
		_endthread();
		CWnd* pWnd;
		pWnd = AfxGetMainWnd();
		pWnd->SendMessage(WM_CLOSE);
	}

	// MMessageBox\̂烊Xgɒǉ邽߂MMessageBoxCell\̂
	if((Cell = MakeMMessageBoxCell(tempBox)) == NULL)
	{
		// Z̃mێs
		//TRACE("Z쐬łĂȂ");
		_endthread();
		CWnd* pWnd;
		pWnd = AfxGetMainWnd();
		pWnd->SendMessage(WM_CLOSE);
	}
	
	// MMessageBoxCell\̂Xgɒǉ
	if(InsertMMessageBoxCell(Cell) != 0)
	{
		// Xg̍XVɎsƂ̏
		//TRACE("Xgǉs");
		_endthread();
		CWnd* pWnd;
		pWnd = AfxGetMainWnd();
		pWnd->SendMessage(WM_CLOSE);
	}
}


/*******************************************************************************
 ֐  :struct CTCPCommunication::MMessageBoxCell* CTCPCommunication::MakeMMessageBoxCell(struct MMessageBoxCell *PutCell, struct MMessageBox tempBox)
 @\    :MMessageBox\̂MMessageBoxCell\̂iXgpj
     :*PutCell - Xgɒǉ邽߂MMessageBoxCell\
		 :tempBox - XgɒǉĂȂMMessageBox\
 ߂l  : 쐬\̂̃|C^  s NULL
 쐬  :Masahiro Nakajima
 쐬  :
 gp@:MakeMessageQueue()Ă
*******************************************************************************/
struct CTCPCommunication::MMessageBoxCell* CTCPCommunication::MakeMMessageBoxCell(struct MMessageBox tempBox)
{
	struct MMessageBoxCell *tempCell;
	char TimeString[TIME_LENGTH];

	// Z̃m
	tempCell = (struct MMessageBoxCell *)malloc(sizeof(struct MMessageBoxCell));

	// Z̃o[̃m
	tempCell->addr_from = (char *)malloc((NAME_LENGTH) * sizeof(char));
	tempCell->addr_to = (char *)malloc((NAME_LENGTH) * sizeof(char));
	tempCell->time = (char *)malloc((TIME_LENGTH) * sizeof(char));
	tempCell->message = (char *)malloc((RECEIVE_MESSAGE_LENGTH) * sizeof(char));

	// mێsĂ烁bZ[Wł
	if(tempCell == NULL || tempCell->addr_from == NULL || tempCell->addr_to == NULL || tempCell->time == NULL || tempCell->message == NULL)
	{
		//TRACE("mێs");
		return NULL;
	}

	// mۂ̈Ƀf[^i[
	strcpy(tempCell->addr_from, tempBox.addr_from);
	strcpy(tempCell->addr_to, tempBox.addr_to);
	strcpy(tempCell->time, ultoa(tempBox.time, TimeString, 10));
	strcpy(tempCell->message, tempBox.message);
	tempCell->next = NULL;

	// oオZ̃|C^Ԃ
	return tempCell;
}


/*******************************************************************************
 ֐  :int CTCPCommunication::InsertMMessageBoxCell(struct CTCPCommunication::MMessageBoxCell *tempCell)
 @\    :MMessageBoxCell\̂Xgɒǉ
     :*tempCell - XgɒǉMMessageBoxCell\̂̃|C^
 ߂l  :Ȃ
 쐬  :Masahiro Nakajima
 쐬  :
*******************************************************************************/
int CTCPCommunication::InsertMMessageBoxCell(struct CTCPCommunication::MMessageBoxCell *tempCell)
{
	tempCell->next = NULL;
	if(ListLength == 0)
	{
		CellHead = tempCell;
		CellTail = tempCell;
	}
	else
	{
		CellTail->next = tempCell;
		CellTail = tempCell;
	}

	ListLength++;

	return 0;
}


/*******************************************************************************
 ֐  :void CTCPCommunication::DeleteCellTail()
 @\    :c[Cell폜
     :*Cell - 폜Cell̃|C^
 ߂l  :Ȃ
 쐬  :Masahiro Nakajima
 쐬  :
*******************************************************************************/
void CTCPCommunication::DeleteCell()
{
	struct MMessageBoxCell *temp;

	temp = CellHead->next;
	free(CellHead->addr_from);
	free(CellHead->addr_to);
	free(CellHead->time);
	free(CellHead->message);
	free(CellHead);
	CellHead = temp;

	ListLength--;
}
